; sounds.s

	.module sounds
    
	; ********************
	;  DECLARE GLOBAL TABLES
	; ********************
	
	.globl  _snd_table
	.globl  _music
    
	.area _CODE

	; ********************
	;  BASS + DRUM
	; ********************

ch0_A:
	.db 0x02,0x33,0x0c,0x1c,0x32
	.db 0x02,0x33,0x0c,0x1c,0x32
	.db 0x02,0x25,0x0c,0x1c,0x12
	.db 0x02,0x33,0x06,0x1c,0x32
	.db 0x02,0x33,0x06,0x1c,0x32
	.db 0x02,0x33,0x0c,0x1c,0x32
	.db 0x02,0x33,0x0c,0x1c,0x32
	.db 0x02,0x25,0x0c,0x1c,0x12
	.db 0x02,0x33,0x0c,0x1c,0x32
	.db 0x18
	
ch3_A0:
	.db 0xc1,0xB5,0xf0,0x02,0xcc,0xa5  ; B5 -> 5A
	.db 0xc1,0xB5,0xf0,0x02,0xcc,0xa5  ; B5 -> 5A
	.db 0xc1,0xB5,0xf0,0x02,0xcc,0xa5  ; B5 -> 5A
	.db 0xc1,0xB5,0xf0,0x02,0xcc,0xa5  ; B5 -> 5A
	.db 0xc1,0x88,0xf0,0x02,0xcc,0xbc  ; 88 -> 44
	.db 0xc1,0x88,0xf0,0x02,0xcc,0xbc  ; 88 -> 44
	.db 0xc1,0x88,0xf0,0x02,0xcc,0xbc  ; 88 -> 44
	.db 0xc1,0x88,0xf0,0x02,0xcc,0xbc  ; 88 -> 44
ch3_A1:
	.db 0xc1,0xB5,0xf0,0x02,0xcc,0xa5  ; B5 -> 5A
	.db 0xc1,0xB5,0xf0,0x02,0xcc,0xa5  ; B5 -> 5A
	.db 0xc1,0xB5,0xf0,0x02,0xcc,0xa5  ; B5 -> 5A
	.db 0xc1,0xB5,0xf0,0x02,0xcc,0xa5  ; B5 -> 5A
	.db 0xc1,0x88,0xf0,0x02,0xcc,0xbc  ; 88 -> 44
	.db 0xc1,0x88,0xf0,0x02,0xcc,0xbc  ; 88 -> 44
	.db 0xc1,0x88,0xf0,0x02,0xcc,0xbc  ; 88 -> 44
	.db 0xc1,0x79,0xf0,0x02,0xcc,0xf9  ; 79 -> 72
	
ch3_A2:
	.db 0xc1,0xCB,0xf0,0x02,0xcc,0x9b  ; CB -> 66
	.db 0xc1,0xCB,0xf0,0x02,0xcc,0x9b  ; CB -> 66
	.db 0xc1,0xCB,0xf0,0x02,0xcc,0x9b  ; CB -> 66
	.db 0xc1,0xCB,0xf0,0x02,0xcc,0x9b  ; CB -> 66
	.db 0xc1,0x72,0xf0,0x02,0xcc,0xc7  ; 72 -> 39
	.db 0xc1,0x72,0xf0,0x02,0xcc,0xc7  ; 72 -> 39
	.db 0xc1,0x72,0xf0,0x02,0xcc,0xc7  ; 72 -> 39
	.db 0xc1,0x72,0xf0,0x02,0xcc,0xc7  ; 72 -> 39
	
ch3_B:
	.db 0xc1,0x88,0xf0,0x02,0xcc,0xbc  ; 88 -> 44
	.db 0xc1,0x88,0xf0,0x02,0xcc,0xbc  ; 88 -> 44
	.db 0xc1,0x88,0xf0,0x02,0xcc,0xbc  ; 88 -> 44
	.db 0xc1,0x88,0xf0,0x02,0xcc,0xbc  ; 88 -> 44
	.db 0xc1,0xB5,0xf0,0x02,0xcc,0xa5  ; B5 -> 5A
	.db 0xc1,0xB5,0xf0,0x02,0xcc,0xa5  ; B5 -> 5A
	.db 0xc1,0xB5,0xf0,0x02,0xcc,0xa5  ; B5 -> 5A
	.db 0xc1,0xB5,0xf0,0x02,0xcc,0xa5  ; B5 -> 5A
	.db 0xd8

ch3_C:
	.db 0xc0,0x5a,0xf0,0x18
	.db 0xc0,0x79,0xf0,0x18
	.db 0xd8

	; ********************
	;  MELODY
	; ********************
	
ch2_A0:
	.db 0x82,0x53,0x81,0x0c,0xe3,0x11
	.db 0x80,0x53,0xa1,0x0c
	.db 0xac
	.db 0x82,0xC5,0x81,0x06,0xe3,0x11
	.db 0x82,0xAB,0x81,0x06,0xe3,0x11
	.db 0x81, 0x81, 0x41, 0x03, 0x22, 0xFc
	.db 0x81, 0x79, 0x41, 0x03, 0x22, 0x04
	.db 0x81, 0x81, 0x41, 0x03, 0x22, 0xFc
	.db 0x81, 0x79, 0x41, 0x03, 0x22, 0x04
	.db 0x82,0xab,0x81,0x0c,0xe3,0x11
	.db 0x82,0xc5,0x81,0x0c,0xe3,0x11
	.db 0x82,0xfc,0x91,0x0c,0xe3,0x11
	.db 0x80,0xfc,0xb1,0x0c
	.db 0xac
	.db 0x82,0xfc,0x91,0x06,0xe3,0x11
	.db 0x82,0xAB,0x81,0x06,0xe3,0x11
	.db 0x81, 0x57, 0x41, 0x03, 0x22, 0xFc
	.db 0x81, 0x4f, 0x41, 0x03, 0x22, 0x04
	.db 0x81, 0x57, 0x41, 0x03, 0x22, 0xFc
	.db 0x81, 0x4f, 0x41, 0x03, 0x22, 0x04
	.db 0x82,0x7d,0x81,0x0c,0xe3,0x11
	.db 0x82,0xab,0x81,0x0c,0xe3,0x11
ch2_A1:
	.db 0x82,0xc5,0x81,0x0c,0xe3,0x11
	.db 0x80,0xc5,0xa1,0x0c
	.db 0xac
	.db 0x82,0xC5,0x91,0x06,0xe3,0x11
	.db 0x82,0xAB,0x81,0x06,0xe3,0x11
	.db 0x81, 0x81, 0x41, 0x03, 0x22, 0xFc
	.db 0x81, 0x79, 0x41, 0x03, 0x22, 0x04
	.db 0x81, 0x81, 0x41, 0x03, 0x22, 0xFc
	.db 0x81, 0x79, 0x41, 0x03, 0x22, 0x04
	.db 0x81, 0x57, 0x41, 0x03, 0x22, 0xFc
	.db 0x81, 0x4f, 0x41, 0x03, 0x22, 0x04
	.db 0x81, 0x57, 0x41, 0x03, 0x22, 0xFc
	.db 0x81, 0x4f, 0x41, 0x03, 0x22, 0x04
	.db 0x82,0xab,0x81,0x0c,0xe3,0x11
	.db 0x80,0xab,0xc1,0x0c
	.db 0x82,0xfc,0x91,0x0c,0xe3,0x11
	.db 0x80,0xfc,0xd1,0x0c
	.db 0x82,0xfc,0x91,0x0c,0xe3,0x11
	;
	.db 0x81, 0x7F, 0x30, 0x03, 0x11, 0x3F
	.db 0x81, 0x7F, 0x60, 0x03, 0x11, 0x3F
	.db 0x81, 0x7F, 0x90, 0x03, 0x11, 0x3F
	.db 0x81, 0x7F, 0xc0, 0x03, 0x11, 0x3F
	;
	.db 0x81, 0x7F, 0x30, 0x03, 0x11, 0x3F
	.db 0x81, 0x7F, 0x60, 0x03, 0x11, 0x3F
	.db 0x81, 0x7F, 0x90, 0x03, 0x11, 0x3F
	.db 0x81, 0x7F, 0xc0, 0x03, 0x11, 0x3F
	;
	.db 0x81, 0x7F, 0x30, 0x03, 0x11, 0x3F
	.db 0x81, 0x7F, 0x60, 0x03, 0x11, 0x3F
	.db 0x81, 0x7F, 0x90, 0x03, 0x11, 0x3F
	.db 0x81, 0x7F, 0xc0, 0x03, 0x11, 0x3F
ch2_A2:	
	.db 0x82,0x7d,0x81,0x0c,0xe3,0x11
	.db 0x80,0x7d,0xa1,0x0c
	.db 0xac
	.db 0x82,0x7d,0x81,0x06,0xe3,0x11
	.db 0x82,0x40,0x81,0x06,0xe3,0x11
	.db 0x81, 0x01, 0x41, 0x03, 0x22, 0xFd
	.db 0x81, 0xfb, 0x40, 0x03, 0x22, 0x03
	.db 0x81, 0x01, 0x41, 0x03, 0x22, 0xFd
	.db 0x81, 0xfb, 0x40, 0x03, 0x22, 0x03
	.db 0x82,0x1d,0x81,0x0c,0xe3,0x11
	.db 0x82,0x40,0x81,0x0c,0xe3,0x11
	.db 0x82,0x53,0x81,0x0c,0xe3,0x11
	.db 0x80,0x53,0xa1,0x0c
	.db 0xac
	.db 0x82,0x53,0x91,0x06,0xe3,0x11
	.db 0x82,0x40,0x81,0x06,0xe3,0x11
	.db 0x81, 0x57, 0x41, 0x03, 0x22, 0xFc
	.db 0x81, 0x4f, 0x41, 0x03, 0x22, 0x04
	.db 0x81, 0x57, 0x41, 0x03, 0x22, 0xFc
	.db 0x81, 0x4f, 0x41, 0x03, 0x22, 0x04
	.db 0x82,0x7d,0x81,0x0c,0xe3,0x11
	.db 0x82,0xab,0x81,0x0c,0xe3,0x11
	
ch2_B0:
	.db 0x82,0x53,0x91,0x06,0xe3,0x11
	.db 0x82,0x53,0x81,0x06,0xe3,0x11
	.db 0x82,0x53,0x81,0x06,0xe3,0x11
	.db 0x82,0x53,0x81,0x0c,0xe3,0x11
	.db 0x80,0x53,0xc1,0x06
	.db 0x82,0xab,0x91,0x06,0xe3,0x11
	.db 0x82,0xab,0x81,0x06,0xe3,0x11
	.db 0x82,0xab,0x81,0x06,0xe3,0x11
	.db 0x82,0xab,0x81,0x0c,0xe3,0x11
	.db 0x80,0xab,0xc1,0x06
	.db 0x82,0xab,0x91,0x06,0xe3,0x11
	.db 0x82,0xab,0x81,0x06,0xe3,0x11
	.db 0x82,0xab,0x81,0x06,0xe3,0x11
	.db 0x82,0xab,0x81,0x06,0xe3,0x11

	.db 0x82,0x7d,0x91,0x06,0xe3,0x11
	.db 0x82,0x7d,0x81,0x06,0xe3,0x11
	.db 0x82,0x7d,0x81,0x06,0xe3,0x11
	.db 0x82,0x7d,0x81,0x0c,0xe3,0x11
	.db 0x80,0x7d,0xc1,0x06
	.db 0x82,0xc5,0x91,0x06,0xe3,0x11
	.db 0x82,0xc5,0x81,0x06,0xe3,0x11
	.db 0x82,0xc5,0x81,0x06,0xe3,0x11
	.db 0x82,0xc5,0x81,0x0c,0xe3,0x11
	.db 0x80,0xc5,0xc1,0x06
	.db 0x82,0xc5,0x91,0x06,0xe3,0x11
	.db 0x82,0xc5,0x81,0x06,0xe3,0x11
	.db 0x82,0xc5,0x81,0x06,0xe3,0x11
	.db 0x82,0xc5,0x81,0x06,0xe3,0x11

ch2_B1:
	.db 0x82,0xab,0x91,0x06,0xe3,0x11
	.db 0x82,0xab,0x81,0x06,0xe3,0x11
	.db 0x82,0xab,0x81,0x06,0xe3,0x11
	.db 0x82,0xab,0x81,0x0c,0xe3,0x11
	.db 0x80,0xab,0xc1,0x06
	.db 0x82,0xfc,0x91,0x06,0xe3,0x11
	.db 0x82,0xfc,0x81,0x06,0xe3,0x11
	.db 0x82,0xfc,0x81,0x06,0xe3,0x11
	.db 0x82,0xfc,0x81,0x0c,0xe3,0x11
	.db 0x80,0xfc,0xc1,0x06
	.db 0x82,0xfc,0x91,0x06,0xe3,0x11
	.db 0x82,0xfc,0x81,0x06,0xe3,0x11
	.db 0x82,0xfc,0x81,0x06,0xe3,0x11
	.db 0x82,0xfc,0x81,0x06,0xe3,0x11

	.db 0x81, 0x20, 0x42, 0x03, 0x22, 0xFb
	.db 0x81, 0x16, 0x42, 0x03, 0x22, 0x05
	.db 0x81, 0x20, 0x42, 0x03, 0x22, 0xFb
	.db 0x81, 0x16, 0x42, 0x03, 0x22, 0x05
	.db 0x82,0xa7,0x82,0x0c,0xe3,0x11
	.db 0x81, 0xca, 0x41, 0x03, 0x22, 0xFb
	.db 0x81, 0xc0, 0x41, 0x03, 0x22, 0x05
	.db 0x81, 0xca, 0x41, 0x03, 0x22, 0xFb
	.db 0x81, 0xc0, 0x41, 0x03, 0x22, 0x05
	.db 0x81, 0xca, 0xc1, 0x03, 0x22, 0xFb
	.db 0x81, 0xc0, 0xc1, 0x03, 0x22, 0x05
	;
	.db 0x81, 0x55, 0x30, 0x03, 0x11, 0x2a
	.db 0x81, 0x55, 0x60, 0x03, 0x11, 0x2a
	.db 0x81, 0x55, 0x90, 0x03, 0x11, 0x2a
	.db 0x81, 0x55, 0xc0, 0x03, 0x11, 0x2a
	;
	.db 0x81, 0x55, 0x30, 0x03, 0x11, 0x2a
	.db 0x81, 0x55, 0x60, 0x03, 0x11, 0x2a
	.db 0x81, 0x55, 0x90, 0x03, 0x11, 0x2a
	.db 0x81, 0x55, 0xc0, 0x03, 0x11, 0x2a

ch2_B2:
	.db 0x81, 0xaf, 0x41, 0x03, 0x22, 0xFc
	.db 0x81, 0xa7, 0x41, 0x03, 0x22, 0x04
	.db 0x81, 0xaf, 0x41, 0x03, 0x22, 0xFc
	.db 0x81, 0xa7, 0x41, 0x03, 0x22, 0x04
	.db 0x81, 0x57, 0x41, 0x03, 0x22, 0xFc
	.db 0x81, 0x4f, 0x41, 0x03, 0x22, 0x04
	.db 0x81, 0x57, 0x41, 0x03, 0x22, 0xFc
	.db 0x81, 0x4f, 0x41, 0x03, 0x22, 0x04
	.db 0x81, 0x02, 0x41, 0x03, 0x22, 0xFc
	.db 0x81, 0xfa, 0x40, 0x03, 0x22, 0x04
	.db 0x81, 0x02, 0x41, 0x03, 0x22, 0xFc
	.db 0x81, 0xfa, 0x40, 0x03, 0x22, 0x04
	.db 0x81, 0x02, 0x41, 0x03, 0x22, 0xFc
	.db 0x81, 0xfa, 0x40, 0x03, 0x22, 0x04
	.db 0x81, 0x02, 0x41, 0x03, 0x22, 0xFc
	.db 0x81, 0xfa, 0x40, 0x03, 0x22, 0x04
	.db 0x81, 0x11, 0x41, 0x03, 0x22, 0xFc
	.db 0x81, 0x09, 0x41, 0x03, 0x22, 0x04
	.db 0x81, 0x11, 0x41, 0x03, 0x22, 0xFc
	.db 0x81, 0x09, 0x41, 0x03, 0x22, 0x04
	.db 0x81, 0x11, 0x41, 0x03, 0x22, 0xFc
	.db 0x81, 0x09, 0x41, 0x03, 0x22, 0x04
	.db 0x81, 0x11, 0x41, 0x03, 0x22, 0xFc
	.db 0x81, 0x09, 0x41, 0x03, 0x22, 0x04
	.db 0x81, 0x11, 0x41, 0x03, 0x22, 0xFc
	.db 0x81, 0x09, 0x41, 0x03, 0x22, 0x04
	;
	.db 0x81, 0x55, 0x30, 0x03, 0x11, 0x2a
	.db 0x81, 0x55, 0x60, 0x03, 0x11, 0x2a
	.db 0x81, 0x55, 0x90, 0x03, 0x11, 0x2a
	.db 0x81, 0x55, 0xc0, 0x03, 0x11, 0x2a
	;
	.db 0x81, 0x55, 0x30, 0x03, 0x11, 0x2a
	.db 0x81, 0x55, 0x60, 0x03, 0x11, 0x2a
	.db 0x81, 0x55, 0x90, 0x03, 0x11, 0x2a
	.db 0x81, 0x55, 0xc0, 0x03, 0x11, 0x2a
	;
	.db 0x81, 0x55, 0x30, 0x03, 0x11, 0x2a
	.db 0x81, 0x55, 0x60, 0x03, 0x11, 0x2a
	.db 0x81, 0x55, 0x90, 0x03, 0x11, 0x2a
	.db 0x81, 0x55, 0xc0, 0x03, 0x11, 0x2a
;	.db 0x90

ch2_C0:
	.db 0x82,0xa7,0x82,0x0c,0xe3,0x11
	.db 0x82,0xa7,0x82,0x06,0xe3,0x11
	.db 0x82,0xa7,0x82,0x06,0xe3,0x11
	.db 0x82,0x8a,0x83,0x0c,0xe3,0x11
	.db 0x82,0x8a,0x83,0x06,0xe3,0x11
	.db 0x82,0x8a,0x83,0x06,0xe3,0x11
	.db 0x98
	;
ch2_C1:
	.db 0x82,0x53,0x81,0x0c,0xe3,0x11
	.db 0x82,0x53,0x81,0x06,0xe3,0x11
	.db 0x82,0x53,0x81,0x06,0xe3,0x11
	.db 0x82,0xc5,0x81,0x0c,0xe3,0x11
	.db 0x82,0xc5,0x81,0x06,0xe3,0x11
	.db 0x82,0xc5,0x81,0x06,0xe3,0x11
	.db 0x98
	
ch2_C2:
	.db 0x82,0xE2,0x30,0x0c,0x82,0x66
	.db 0x82,0xAA,0x30,0x0c,0x82,0x66
	.db 0x82,0xB4,0x30,0x0c,0x82,0x66
	.db 0x82,0xAA,0x30,0x0c,0x82,0x66
	.db 0x82,0xE2,0x30,0x0c,0x82,0x66
	.db 0x82,0xD6,0x30,0x0c,0x82,0x66
	.db 0x82,0xFE,0x30,0x0c,0x82,0x66
	.db 0x82,0xE2,0x30,0x0c,0x82,0x66
	.db 0x82,0x1D,0x31,0x0c,0x82,0x66
	.db 0x82,0xFE,0x30,0x0c,0x82,0x66
	.db 0x82,0x2E,0x31,0x0c,0x82,0x66
	.db 0x82,0x1D,0x31,0x0c,0x82,0x66
	.db 0x82,0x53,0x31,0x0c,0x82,0x66
	.db 0x82,0x2E,0x31,0x0c,0x82,0x66
	.db 0x82,0x67,0x31,0x0c,0x82,0x66
	.db 0x82,0x53,0x31,0x0c,0x82,0x66
	.db 0x82,0xc5,0x31,0x0c,0x82,0x66
	.db 0x82,0x94,0x31,0x0c,0x82,0x66
	.db 0x82,0x67,0x31,0x0c,0x82,0x66
	.db 0x82,0x53,0x31,0x0c,0x82,0x66
ch2_C3:
	.db 0x82,0xc5,0x31,0x0c,0x82,0x66
	.db 0x82,0x67,0x31,0x0c,0x82,0x66
	.db 0x82,0x2e,0x31,0x0c,0x82,0x66
	.db 0x82,0x53,0x31,0x0c,0x82,0x66
	.db 0x98



	; ********************
	;  SOUNDs FX
	; ********************

fx_turn_ch1:
	.db 0x41, 0x39, 0x30, 0x03, 0x11, 0x1C
	.db 0x41, 0x39, 0x60, 0x03, 0x11, 0x1C
	.db 0x41, 0x39, 0x90, 0x03, 0x11, 0x1C
	.db 0x50
	
fx_inplace_ch1:
	.db 0x41, 0x55, 0x30, 0x02, 0x11, 0x55
	.db 0x41, 0x55, 0x50, 0x02, 0x11, 0x55
	.db 0x41, 0x55, 0x70, 0x02, 0x11, 0x55
	.db 0x41, 0x2A, 0x30, 0x02, 0x11, 0x2A
	.db 0x41, 0x2A, 0x50, 0x02, 0x11, 0x2A
	.db 0x41, 0x2A, 0x70, 0x02, 0x11, 0x2A
	.db 0x50
        
fx_explosion_ch0:
	.db 0x02,0x07,0x06,0x18,0x12
	.db 0x00,0x00,0x17,0x10
	.db 0x00,0x00,0x57,0x10
	.db 0x10
fx_explosion_ch3:
	.db 0xc1,0x50,0xf0,0x06,0x11,0x10
	.db 0xc1,0x50,0xf0,0x10,0x11,0x08
	.db 0xc1,0x50,0xf0,0x10,0x11,0x08
	.db 0xd0

	; ********************
	;  SOUNDs TABLE
	; ********************

_snd_table:
	.dw    #ch0_A,0x702b                    ; = 1
	.dw    #fx_turn_ch1,0x702b+40        ; = 2
	.dw    #fx_inplace_ch1,0x702b+40    ; = 3
	.dw    #fx_explosion_ch0,0x702b+40  ; = 4
	.dw    #fx_explosion_ch3,0x702b+50  ; = 5
	.dw    #ch3_A0,0x702b+10              ; = 6
	.dw    #ch3_A1,0x702b+10              ; = 7
	.dw    #ch3_A2,0x702b+10              ; = 8
	.dw    #ch3_B,0x702b+10               ; = 9	
	.dw    #ch2_A0,0x702b+20              ; = A
	.dw    #ch2_A1,0x702b+20              ; = B
	.dw    #ch2_A2,0x702b+20              ; = C
	.dw    #ch2_B0,0x702b+20              ; = D
	.dw    #ch2_B1,0x702b+20              ; = E
	.dw    #ch2_B2,0x702b+20              ; = F

	.dw    #ch3_C,0x702b+10               ; = 10
	.dw    #ch2_C0,0x702b+20              ; = 11
	.dw    #ch2_C1,0x702b+20              ; = 12
	.dw    #ch2_C2,0x702b+20              ; = 13
	.dw    #ch2_C3,0x702b+20              ; = 14

	; ********************
	;  MUSIC SEQUENCE
	; ********************
	
_music:
    .dw 0x00c0
    .db 0x81,0x06,0x0a
    .dw 0x00c0
    .db 0x81,0x07,0x0b
    .dw 0x00c0
    .db 0x81,0x08,0x0c
    .dw 0x00c0
    .db 0x81,0x06,0x0b

    .dw 0x00c0
    .db 0x81,0x06,0x0a
    .dw 0x00c0
    .db 0x81,0x07,0x0b
    .dw 0x00c0
    .db 0x81,0x08,0x0c
    .dw 0x00c0
    .db 0x81,0x06,0x0b

    .dw 0x00c0
    .db 0x81,0x09,0x0d
    .dw 0x00c0
    .db 0x81,0x09,0x0e
    .dw 0x00c0
    .db 0x81,0x09,0x0d
    .dw 0x00c0
    .db 0x81,0x09,0x0f

    .dw 0x00c0
    .db 0x81,0x06,0x0a
    .dw 0x00c0
    .db 0x81,0x07,0x0b
    .dw 0x00c0
    .db 0x81,0x08,0x0c
    .dw 0x00c0
    .db 0x81,0x06,0x0b

    .dw 0x00c0
    .db 0x81,0x10,0x11
    .dw 0x00c0
    .db 0x81,0x10,0x12
    .dw 0x0240
    .db 0x81,0x10,0x13
    .dw 0x0060
    .db 0x81,0x10,0x11
    .dw 0x0030
    .db 0x81,0x10,0x14    
    .dw 0x00c0
    .db 0x81,0x10,0x11
    .dw 0x00c0
    .db 0x81,0x10,0x12

    .dw _music
